/*
 * File: CatChase.java
 * ================================================================
 * A program that has a friendly cat track the mouse location.
 */
import acm.program.*;
import acm.graphics.*;
import java.awt.*;
import java.awt.event.*;

public class CatChase extends GraphicsProgram {
	/* The delay time. */
	private static final double PAUSE_TIME = 1000.0 / 48;
	
	/* The cat that tracks the mouse. */
	private GImage cat;
	
	/* The target x and y location. */
	private double targetX;
	private double targetY;

	/* Sets up the canvas. */
	public void init() {
		addMouseListeners();
	}
	
	/* Continuously moves the cat toward the mouse. */
	public void run() {
		createCat();
		
		while (true) {
			moveToTarget();
			pause(PAUSE_TIME);
		}
	}
	
	/**
	 * Moves the cat one step closer to the mouse.
	 */
	private void moveToTarget() {
		/* Compute the center of the cat. */
		double x = cat.getX() + cat.getWidth() / 2.0;
		double y = cat.getY() + cat.getHeight() / 2.0;
		
		/* Track what delta we should move by. */
		double dx = 0;
		double dy = 0;
		
		/* Adjust the x velocity based on our relationship to
		 * the target.
		 */
		if (x < targetX) {
			dx = 1;
		} else if (x > targetX) {
			dx = -1;
		}
		
		/* Adjust the y velocity based on our relationship to
		 * the target.
		 */
		if (y < targetY) {
			dy = 1;
		} else if (y > targetY) {
			dy = -1;
		}
		
		/* Take one step closer. */
		cat.move(dx, dy);
	}
	
	/**
	 * Creates a friendly cat and adds it to the screen. 
	 */
	private void createCat() {
		cat = new GImage("Cat.jpg");
		add(cat);
	}
	
	/**
	 * Updates the target position based on where the mouse is.
	 * 
	 * @param e The MouseEvent with mouse information.
	 */
	public void mouseMoved(MouseEvent e) {
		targetX = e.getX();
		targetY = e.getY();
	}
}
